/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.resizers;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Map;
import net.coobird.thumbnailator.resizers.AbstractResizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressiveBilinearResizer
extends AbstractResizer {
    public ProgressiveBilinearResizer() {
        this(Collections.emptyMap());
    }

    public ProgressiveBilinearResizer(Map<RenderingHints.Key, Object> map2) {
        super(RenderingHints.VALUE_INTERPOLATION_BILINEAR, map2);
    }

    @Override
    public void resize(BufferedImage bufferedImage, BufferedImage bufferedImage2) throws NullPointerException {
        int n;
        super.performChecks(bufferedImage, bufferedImage2);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = bufferedImage2.getWidth();
        int n5 = bufferedImage2.getHeight();
        if (n4 * 2 >= n2 && n5 * 2 >= n3) {
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage(bufferedImage, 0, 0, n4, n5, null);
            graphics2D.dispose();
            return;
        }
        BufferedImage bufferedImage3 = new BufferedImage(n2, n3, bufferedImage2.getType());
        Graphics2D graphics2D = bufferedImage3.createGraphics();
        graphics2D.setRenderingHints(this.RENDERING_HINTS);
        graphics2D.setComposite(AlphaComposite.Src);
        int n6 = n4;
        for (n = n5; n6 < n2 && n < n3; n6 *= 2, n *= 2) {
        }
        n2 = n6 / 2;
        n3 = n / 2;
        graphics2D.drawImage(bufferedImage, 0, 0, n2, n3, null);
        while (n2 >= n4 * 2 && n3 >= n5 * 2) {
            n3 /= 2;
            if ((n2 /= 2) < n4) {
                n2 = n4;
            }
            if (n3 < n5) {
                n3 = n5;
            }
            graphics2D.drawImage(bufferedImage3, 0, 0, n2, n3, 0, 0, n2 * 2, n3 * 2, null);
        }
        graphics2D.dispose();
        Graphics2D graphics2D2 = bufferedImage2.createGraphics();
        graphics2D2.drawImage(bufferedImage3, 0, 0, n4, n5, 0, 0, n2, n3, null);
        graphics2D2.dispose();
    }
}

